/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.FailureDetected;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.MessageQueue;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;

public class FailureDetector {
    static final long PROCESS_FAILURE_TIMEOUT = 300000L;
    static byte[] lock = new byte[0];
    static Address coordinator;
    static String nodelistenerHostname;

    public static Vector getLatestView() throws GroupException, InterruptedException {
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        View view = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        if (view != null) {
            return view.getMembers();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCoordinator(Address address) {
        byte[] byArray = lock;
        synchronized (lock) {
            coordinator = address;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (GroupCommunication.shouldLog(7)) {
                GroupCommunication.log("Set coordinator as " + address);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getCoordinator() {
        byte[] byArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setNodeListenerHostname(String string) {
        byte[] byArray = lock;
        synchronized (lock) {
            nodelistenerHostname = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getNodeListenerHostname() {
        byte[] byArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return nodelistenerHostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Address electNewCoordinator() throws GroupException, InterruptedException {
        Address address = null;
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        View view = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        Vector vector = view.getMembers();
        byte[] byArray = lock;
        synchronized (lock) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null) continue;
                address = (Address)vector.elementAt(i);
                if (Transport.isMyself(address)) {
                    FailureDetector.setCoordinator(address);
                    Transport.broadcastConfirmation(address);
                    break;
                }
                Hashtable hashtable = Transport.getEndPointList();
                if (hashtable.containsKey(address)) break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (address == null) {
                throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL);
            }
            if (GroupCommunication.shouldLog(7)) {
                GroupCommunication.log("Elected new coordinator: " + address.toString(true));
            }
            return address;
        }
    }

    static void failureDetected(Address address) throws InterruptedException {
        FailureDetector.failureDetected(address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void failureDetected(Address address, Object object) throws InterruptedException {
        Object object2;
        Object object3;
        block34: {
            Object var2_2 = null;
            try {
                Object var19_19;
                try {
                    GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                    object3 = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
                    GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                    object2 = ((View)object3).getMembers();
                    Vector vector = (Vector)((Vector)object2).clone();
                    int n = vector.indexOf(address);
                    if (n >= 0 && n < vector.size()) {
                        vector.setElementAt(null, n);
                    }
                    Transport.removeEndPoint(address);
                    boolean bl = false;
                    long l = System.currentTimeMillis();
                    long l2 = l + 300000L;
                    while (!bl) {
                        Object object4;
                        if (address.equals(FailureDetector.getCoordinator())) {
                            object4 = FailureDetector.electNewCoordinator();
                        }
                        if (Transport.isMyself(FailureDetector.getCoordinator())) {
                            FailureDetector.processFailure(address);
                            if (Transport.isNLStarted()) {
                                bl = true;
                            } else {
                                boolean bl2 = false;
                                while (!bl2) {
                                    try {
                                        Address address2 = Transport.getCoordinatorFromANodeListener(Transport.getLocalNodeListenerAddress());
                                        if (address2 != null && Transport.isMyself(address2)) {
                                            bl2 = true;
                                            continue;
                                        }
                                        Transport.terminateNodeListenerAt(Transport.getLocalNodeListenerAddress());
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                    finally {
                                        try {
                                            Thread.sleep(100L);
                                            Transport.startNodeListener();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                bl = true;
                            }
                        } else {
                            if (object != null) {
                                object4 = object;
                                synchronized (object4) {
                                    object.wait(500L);
                                }
                            }
                            bl = FailureDetector.isMemberRemoved(address);
                        }
                        if (System.currentTimeMillis() <= l2) continue;
                        if (!GroupCommunication.shouldLog(3)) break;
                        GroupCommunication.log("Timeout while waiting for coordinator: " + coordinator + " to remove member: " + address + ". Elapsed time: " + (l2 - l) + " msec.");
                        break;
                    }
                }
                catch (Exception exception) {
                    if (GroupCommunication.shouldLog(3)) {
                        GroupCommunication.log("Can NOT handle the failure of " + address.toString(true), exception);
                    }
                    var19_19 = null;
                    if (Transport.getLocalAddress().getIPString().equals(address.getIPString())) {
                        Transport.startNodeListener();
                    }
                    break block34;
                }
                var19_19 = null;
                if (!Transport.getLocalAddress().getIPString().equals(address.getIPString())) break block34;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (Transport.getLocalAddress().getIPString().equals(address.getIPString())) {
                    Transport.startNodeListener();
                }
                throw throwable;
            }
            Transport.startNodeListener();
        }
        object3 = Transport.receivingQList.elements();
        while (object3.hasMoreElements()) {
            object2 = (MessageQueue)object3.nextElement();
            object2.enqueue(new GroupMessage(2, new FailureDetected(address)));
        }
        return;
    }

    static boolean isMemberRemoved(Address address) throws InterruptedException {
        boolean bl = false;
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        View view = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        if (view != null && view.getMembers() != null && !view.getMembers().contains(address)) {
            bl = true;
        }
        return bl;
    }

    static void processFailure(Address address) throws GroupException, IOException, InterruptedException {
        GroupManager.leaveGroup(GroupManager.SYSTEM_GROUP, address);
    }

    static {
        nodelistenerHostname = null;
    }
}

